/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSGenericConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3341;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5539;
import net.minecraft.class_6622;
import net.minecraft.class_6834;

public class LandBasedEndStructure<C extends RSGenericConfig>
extends GenericJigsawStructure<C> {
    public LandBasedEndStructure(Codec<C> codec) {
        super(codec, LandBasedEndStructure::isLandFeatureChunk, LandBasedEndStructure::generateLandPieces);
    }

    protected static <CC extends RSGenericConfig> boolean isLandFeatureChunk(class_6834.class_6835<CC> context) {
        int zBlockPos;
        int radius = 1000;
        int xBlockPos = context.comp_309().method_8326();
        if (xBlockPos * xBlockPos + (zBlockPos = context.comp_309().method_8328()) * zBlockPos <= radius * radius) {
            return false;
        }
        return GenericJigsawStructure.isGenericFeatureChunk(context) && LandBasedEndStructure.getTerrainHeight(context.comp_309(), context.comp_306(), context.comp_311()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.comp_306()), 50);
    }

    private static int getTerrainHeight(class_1923 chunkPos1, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int xPos = chunkPos1.field_9181 << 4;
        int zPos = chunkPos1.field_9180 << 4;
        int height = chunkGenerator.method_18028(xPos, zPos, class_2902.class_2903.field_13194, heightLimitView);
        class_2338 pos = new class_2338(xPos, GeneralUtils.getMaxTerrainLimit(chunkGenerator), zPos);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13194, heightLimitView));
        }
        return height;
    }

    public static <CC extends RSGenericConfig> Optional<class_6622<CC>> generateLandPieces(class_6834.class_6835<CC> context) {
        RSGenericConfig config = (RSGenericConfig)context.comp_310();
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), config.setFixedYSpawn, context.comp_309().method_8328());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), blockpos, !config.doNotUseHeightmap, !config.doNotUseHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            class_3341 box = ((class_3790)pieces.get(0)).method_14935();
            class_2338 centerPos = new class_2338((class_2382)box.method_22874());
            int radius = (int)Math.sqrt(box.method_14659().method_10263() * box.method_14659().method_10263() + box.method_14659().method_10260() * box.method_14659().method_10260()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.comp_306().method_18028(centerPos.method_10263() + xOffset, centerPos.method_10260() + zOffset, class_2902.class_2903.field_13194, context.comp_311());
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((class_3790)pieces.get(0)).method_14935().method_35416();
            int offsetAmount = avgHeight - parentHeight + config.centerYOffset;
            pieces.forEach(child -> child.method_14922(0, offsetAmount, 0));
        });
    }
}

